<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:javaFile="javaFile:java.io.File" exclude-result-prefixes="javaFile">
	<xsl:script language="java" implements-prefix="javaFile" src="java:java.io.File"/>
	<!-- This file (methodlinks.xsl) contains the linking logic for methods -->
	<!-- ################### Template methodlinks ###################### -->
	<!-- This template builds links for methods that are inherited, but that
     are not listed in the members list  -->
	<xsl:template name="methodlinks">
		<xsl:variable name="class" select="@name"/>
		<xsl:variable name="context" select="."/>
		<xsl:for-each select=".//methodref">
			<xsl:variable name="methrefname" select="@name"/>
			<!-- Make sure it's not published locally -->
			<xsl:choose>
				<xsl:when test="count($context//method[@name=$methrefname and @hasdoc='yes']
									| $context//procedure[@name=$methrefname and @hasdoc='yes']
									| $context//function[@name=$methrefname and @hasdoc='yes'])=0">
                                  <xsl:if test="not(contains($methrefname,'get_')) and not (contains($methrefname,'set_')) and not (contains($methrefname,'add_'))  and not (contains($methrefname,'remove_'))">
					<!-- check for nested classes -->
					<!-- parent is <ancestor>, parent of which is <class> or <interface>, parent of which should be namespace... unless it's in a nested class/interface!-->
					<xsl:choose>
						<xsl:when test="ancestor::class/../../class or ancestor::class/../../interface or ancestor::interface/../../class or ancestor::interface/../../interface">
							<!-- don't include methodrefs in nested classes for now -->
							<!--						<xsl:message>
							<xsl:text>!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!methodREF IN NESTED CLASS/INTERFACE: methodref </xsl:text>
							<xsl:value-of select="$methrefname"/>
							<xsl:text> in </xsl:text>
							<xsl:value-of select="$class"/>
							<xsl:text> in </xsl:text>
							<xsl:value-of select="../../@name"/>
							<xsl:text>!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!</xsl:text>
						</xsl:message>-->
						</xsl:when>
						<xsl:otherwise>
							<!-- look for links only for the top methref with this name in this class
						 if it's not documented, other links will be found in recurseancestor -->
							<xsl:choose>
								<xsl:when test="not(ancestor::*[preceding-sibling::methodref[@name=$methrefname]])">
									<!--                                                  <xsl:message>
                                                    Attempting recursion.
                                                  </xsl:message>
-->
									<xsl:call-template name="recurseancestormethods">
										<xsl:with-param name="meth" select="@name"/>
										<xsl:with-param name="class" select="../@name"/>
										<xsl:with-param name="unit" select="../@namespace"/>
									</xsl:call-template>
								</xsl:when>
								<xsl:otherwise>
									<!--                                                  <xsl:message>
                                                    another node: <xsl:copy-of select="ancestor::*[preceding-sibling::methodref[@name=$methrefname]]"/>
                                                  </xsl:message>
-->
								</xsl:otherwise>
							</xsl:choose>
						</xsl:otherwise>
					</xsl:choose>
                                    
                                  </xsl:if>

				</xsl:when>
				<xsl:otherwise>
					<!--                          <xsl:message>
                            Count: <xsl:copy-of select="$context/members/method[@name=$methrefname and @hasdoc='yes']"/>
                          </xsl:message>-->
				</xsl:otherwise>
			</xsl:choose>
		</xsl:for-each>
		
		<!-- #### links to members of implemented interfaces #### -->
		<xsl:for-each select=".//method[boolean(@declaring_interface)] 
							| .//procedure[boolean(@declaring_interface)] 
							| ../function[boolean(@declaring_interface)]">
			<xsl:variable name="intmethname">
				<xsl:value-of select="@name"/>
			</xsl:variable>
                        <xsl:if test="not(contains($intmethname,'get_')) and not (contains($intmethname,'set_')) and not (contains($intmethname,'add_')) and not (contains($intmethname,'remove_'))">
			<!-- check for nested classes -->
			<!-- look for class/class in the ancestry
                 or class/interface or interface/class or
                 interface/interface ... -->
			<xsl:choose>
				<xsl:when test="ancestor::class/../../class or ancestor::class/../../interface or ancestor::interface/../../class or ancestor::interface/../../interface">
					<!--
                <xsl:message>
                    <xsl:text>!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!METHODREF IN NESTED INTERFACE: methodref </xsl:text><xsl:value-of select="$intprocname"/><xsl:text> in </xsl:text><xsl:value-of select = "$class"/><xsl:text> in </xsl:text><xsl:value-of select="../../@name"/><xsl:text>!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!</xsl:text>
                </xsl:message>
-->
				</xsl:when>
				<xsl:otherwise>
					<xsl:variable name="declaring_interface">
						<xsl:value-of select="@declaring_interface"/>
					</xsl:variable>
					<xsl:variable name="linktarget">
						<xsl:value-of select="//class[@name=$class]/interfaces/implements[contains(@name, $declaring_interface)]/@name"/>
					</xsl:variable>
					<methodlink>
						<xsl:attribute name="declaring_interface"><xsl:value-of select="$declaring_interface"/></xsl:attribute>
						<!-- 07/03/03 SN changed these two tests from $declaring_interface to $linktarget; $declaring_interface doesn't have the full path information (including 'Borland.' -->
						<xsl:if test="not(contains($linktarget, 'Borland'))">
							<xsl:attribute name="docset"><xsl:value-of select="'microsoft'"/></xsl:attribute>
						</xsl:if>
						<xsl:if test="contains($linktarget, 'Borland')">
							<xsl:attribute name="docset"><xsl:value-of select="'borland'"/></xsl:attribute>
						</xsl:if>
						<namespace>
							<xsl:value-of select="substring-before($linktarget, concat('.', $declaring_interface))"/>
						</namespace>
						<interface>
							<xsl:value-of select="$declaring_interface"/>
						</interface>
						<method>
							<xsl:value-of select="$intmethname"/>
						</method>
					</methodlink>
				</xsl:otherwise>
			</xsl:choose>
                      </xsl:if>
		</xsl:for-each>
		
	</xsl:template>

	<!-- ###################### recurseancestor ##############################3 -->
	<!-- This template is a recursive template. It opens the file that the first method of the same name
     in the ancestor list references. If the method is documented in this class, it writes link
     information. If not, it calls itself, with parameters for the *next* ancestor in the ancestor list
     that has a method of the same name.
     -->
	<!-- not worrying about nested classes here, in the ancestor hierarchy... -->
	<xsl:template name="recurseancestormethods">
		<xsl:param name="meth"/>
		<xsl:param name="class"/>
		<xsl:param name="unit"/>
		<!--                <xsl:message>
                  Recursing: <xsl:value-of select="concat($unit,'.',$class,'.',$meth)"/>
                </xsl:message>-->
		<xsl:variable name="classfile" select="concat('compileroutput', '/', $unit, '.xml')"/>
		<!--This next for-each performs operations on each method that we are looking for.-->
		<xsl:variable name="filename" select="javaFile:new($classfile)"/>
		<xsl:choose>
			<xsl:when test="javaFile:exists($filename)">
				<xsl:for-each select="document($classfile)/namespace/class[@name=$class]//method[@name=$meth]	
									| document($classfile)/namespace/class[@name=$class]//procedure[@name=$meth]
									| document($classfile)/namespace/class[@name=$class]//function[@name=$meth]">
					<!-- new criterion: hasdoc = "yes" means it is documented here -->
					<xsl:choose>
						<xsl:when test="@hasdoc='yes'">
							<methodlink>
								<xsl:variable name="linknamespace">
									<xsl:value-of select="/namespace/@name"/>
								</xsl:variable>
								<xsl:if test="contains($linknamespace, 'Borland')">
									<xsl:attribute name="docset">borland</xsl:attribute>
								</xsl:if>
								<xsl:if test="not(contains($linknamespace, 'Borland'))">
									<xsl:attribute name="docset">microsoft</xsl:attribute>
								</xsl:if>
								<namespace>
									<xsl:value-of select="$unit"/>
								</namespace>
								<class>
									<xsl:value-of select="$class"/>
								</class>
								<method>
									<xsl:value-of select="$meth"/>
								</method>
							</methodlink>
						</xsl:when>
						<!-- if it's not one of our namespaces, don't look for doc, just link -->
						<xsl:when test="not(contains($unit,'Borland'))">
							<methodlink>
								<xsl:variable name="linknamespace">
									<xsl:value-of select="/namespace/@name"/>
								</xsl:variable>
								<xsl:if test="contains($linknamespace, 'Borland')">
									<xsl:attribute name="docset">borland</xsl:attribute>
								</xsl:if>
								<xsl:if test="not(contains($linknamespace, 'Borland'))">
									<xsl:attribute name="docset">microsoft</xsl:attribute>
								</xsl:if>
								<namespace>
									<xsl:value-of select="$unit"/>
								</namespace>
								<class>
									<xsl:value-of select="$class"/>
								</class>
								<method>
									<xsl:value-of select="$meth"/>
								</method>
							</methodlink>
						</xsl:when>
						<!-- otherwise don't link it, look at ancestors -->
						<xsl:otherwise>
							<xsl:for-each select="/namespace/class[@name=$class]">
								<!--This for-each selects the first ancestor in the ancestor list that has a
                     method of the same name-->
								<xsl:for-each select="(.//ancestor/methodref[@name=$meth])[1]">
									<!--Here we call the recursive template with parameters for method, class and unit -->
									<xsl:call-template name="recurseancestormethods">
										<xsl:with-param name="meth" select="$meth"/>
										<xsl:with-param name="class" select="../@name"/>
										<xsl:with-param name="unit" select="../@namespace"/>
									</xsl:call-template>
								</xsl:for-each>
							</xsl:for-each>
						</xsl:otherwise>
					</xsl:choose>
					<!--
            <xsl:if test = "not (javaFile:exists($filename))">
              <xsl:message>Unable to open <xsl:value-of select = "$ancestorfile"/> to find method links.</xsl:message>

          </xsl:if>
-->
				</xsl:for-each>
			</xsl:when>
			<xsl:otherwise>
				<!-- if file doesn't exist, set up link anyway -->
				<methodlink>
					<xsl:variable name="linknamespace">
						<xsl:value-of select="$unit"/>
					</xsl:variable>
					<xsl:if test="contains($linknamespace, 'Borland')">
						<xsl:attribute name="docset">borland</xsl:attribute>
					</xsl:if>
					<xsl:if test="not(contains($linknamespace, 'Borland'))">
						<xsl:attribute name="docset">microsoft</xsl:attribute>
					</xsl:if>
					<namespace>
						<xsl:value-of select="$unit"/>
					</namespace>
					<class>
						<xsl:value-of select="$class"/>
					</class>
					<method>
						<xsl:value-of select="$meth"/>
					</method>
				</methodlink>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
